import { ExpoConfig } from '../Config.types';
import { Document } from './Manifest';
export declare const CONFIG_CHANGES_ATTRIBUTE = "android:configChanges";
export declare const ON_CONFIGURATION_CHANGED = "\npublic class MainActivity extends ReactActivity {\n\n    // Added automatically by Expo Config\n    @Override\n    public void onConfigurationChanged(Configuration newConfig) {\n        super.onConfigurationChanged(newConfig);\n        Intent intent = new Intent(\"onConfigurationChanged\");\n        intent.putExtra(\"newConfig\", newConfig);\n        sendBroadcast(intent);\n    }\n";
export declare function getUserInterfaceStyle(config: ExpoConfig): string | null;
export declare function setUiModeAndroidManifest(config: ExpoConfig, manifestDocument: Document): Promise<Document>;
export declare function addOnConfigurationChangedMainActivity(config: ExpoConfig, MainActivity: string): string;
