import { ExpoConfig } from '../Config.types';
import { Document } from './Manifest';
export declare type IntentFilterProps = {
    actions: string[];
    categories: string[];
    schemes: string[];
};
export declare function getScheme(config: {
    scheme?: string | string[];
}): string[];
export declare function setScheme(config: Pick<ExpoConfig, 'scheme' | 'android'>, manifestDocument: Document): Promise<Document>;
export declare function getSchemesFromManifest(manifestDocument: Document): string[];
export declare function ensureManifestHasValidIntentFilter(manifestDocument: Document): boolean;
export declare function hasScheme(scheme: string, manifestDocument: Document): boolean;
export declare function appendScheme(scheme: string, manifestDocument: Document): Document;
export declare function removeScheme(scheme: string, manifestDocument: Document): Document;
