import { ExpoConfig } from '../Config.types';
import { Document, ManifestUsesPermission } from './Manifest';
export declare const requiredPermissions: string[];
export declare const allPermissions: string[];
export declare function getAndroidPermissions(config: ExpoConfig): string[];
export declare function setAndroidPermissions(config: ExpoConfig, manifestDocument: Document): Promise<Document>;
export declare function isPermissionAlreadyRequested(permission: string, manifestPermissions: ManifestUsesPermission[]): boolean;
export declare function addPermissionToManifest(permission: string, manifestPermissions: ManifestUsesPermission[]): ManifestUsesPermission[];
export declare function removePermissions(doc: Document, permissionNames?: string[]): void;
export declare function addPermission(doc: Document, permissionName: string): void;
export declare function ensurePermissions(doc: Document, permissionNames: string[]): {
    [permission: string]: boolean;
};
export declare function ensurePermission(doc: Document, permissionName: string): boolean;
export declare function ensurePermissionNameFormat(permissionName: string): string;
export declare function getPermissions(doc: Document): string[];
