"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = __importDefault(require("fs-extra"));
const glob_1 = require("glob");
const path = __importStar(require("path"));
async function getMainActivityAsync(projectRoot) {
    const mainActivityJavaPath = glob_1.sync(path.join(projectRoot, 'android/app/src/main/java/**/MainActivity.{java,kt}'))[0];
    const mainActivityPathJava = path.resolve(mainActivityJavaPath, '../MainActivity.java');
    const mainActivityPathKotlin = path.resolve(mainActivityJavaPath, '../MainActivity.kt');
    const isJava = await fs_extra_1.default.pathExists(mainActivityPathJava);
    const isKotlin = !isJava && (await fs_extra_1.default.pathExists(mainActivityPathKotlin));
    if (!isJava && !isKotlin) {
        throw new Error(`Failed to find 'MainActivity' file for project: ${projectRoot}.`);
    }
    return {
        path: isJava ? mainActivityPathJava : mainActivityPathKotlin,
        language: isJava ? 'java' : 'kt',
    };
}
exports.getMainActivityAsync = getMainActivityAsync;
function getAndroidBuildGradle(projectRoot) {
    return path.join(projectRoot, 'android', 'build.gradle');
}
exports.getAndroidBuildGradle = getAndroidBuildGradle;
function getAppBuildGradle(projectRoot) {
    return path.join(projectRoot, 'android', 'app', 'build.gradle');
}
exports.getAppBuildGradle = getAppBuildGradle;
async function getProjectPathOrThrowAsync(projectRoot) {
    const projectPath = path.join(projectRoot, 'android');
    if (await directoryExistsAsync(projectPath)) {
        return projectPath;
    }
    throw new Error(`Android project folder is missing in project: ${projectRoot}`);
}
exports.getProjectPathOrThrowAsync = getProjectPathOrThrowAsync;
async function getAndroidManifestAsync(projectRoot) {
    const projectPath = await getProjectPathOrThrowAsync(projectRoot);
    const filePath = path.join(projectPath, 'app/src/main/AndroidManifest.xml');
    // if (await fileExistsAsync(filePath)) {
    return filePath;
    // }
}
exports.getAndroidManifestAsync = getAndroidManifestAsync;
async function getResourceXMLPathAsync(projectRoot, { kind = 'values', name }) {
    const projectPath = await getProjectPathOrThrowAsync(projectRoot);
    const filePath = path.join(projectPath, `app/src/main/res/${kind}/${name}.xml`);
    return filePath;
}
exports.getResourceXMLPathAsync = getResourceXMLPathAsync;
/**
 * A non-failing version of async FS stat.
 *
 * @param file
 */
async function statAsync(file) {
    try {
        return await fs_extra_1.default.stat(file);
    }
    catch (_a) {
        return null;
    }
}
async function fileExistsAsync(file) {
    var _a, _b;
    return (_b = (_a = (await statAsync(file))) === null || _a === void 0 ? void 0 : _a.isFile()) !== null && _b !== void 0 ? _b : false;
}
exports.fileExistsAsync = fileExistsAsync;
async function directoryExistsAsync(file) {
    var _a, _b;
    return (_b = (_a = (await statAsync(file))) === null || _a === void 0 ? void 0 : _a.isDirectory()) !== null && _b !== void 0 ? _b : false;
}
//# sourceMappingURL=Paths.js.map