"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Manifest_1 = require("./Manifest");
exports.SCREEN_ORIENTATION_ATTRIBUTE = 'android:screenOrientation';
function getOrientation(config) {
    return typeof config.orientation === 'string' ? config.orientation : null;
}
exports.getOrientation = getOrientation;
async function setAndroidOrientation(config, manifestDocument) {
    const orientation = getOrientation(config);
    if (!orientation) {
        return manifestDocument;
    }
    let mainActivity = Manifest_1.getMainActivity(manifestDocument);
    if (!mainActivity) {
        mainActivity = { $: { 'android:name': '.MainActivity' } };
    }
    mainActivity['$'][exports.SCREEN_ORIENTATION_ATTRIBUTE] =
        orientation !== 'default' ? orientation : 'unspecified';
    return manifestDocument;
}
exports.setAndroidOrientation = setAndroidOrientation;
//# sourceMappingURL=Orientation.js.map