"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Resources_1 = require("./Resources");
const Strings_1 = require("./Strings");
const XML_1 = require("./XML");
function getName(config) {
    return typeof config.name === 'string' ? config.name : null;
}
exports.getName = getName;
/**
 * Changes the display name on the home screen,
 * notifications, and others.
 */
async function setName(configOrName, projectDirectory) {
    let name = null;
    if (typeof configOrName === 'string') {
        name = configOrName;
    }
    else {
        name = getName(configOrName);
    }
    if (!name) {
        // TODO: Maybe just remove the value from strings instead?
        return false;
    }
    const stringsPath = await Strings_1.getProjectStringsXMLPathAsync(projectDirectory);
    if (!stringsPath) {
        throw new Error(`There was a problem setting your Facebook App ID in ${stringsPath}.`);
    }
    let stringsJSON = await Resources_1.readResourcesXMLAsync({ path: stringsPath });
    stringsJSON = applyName(name, stringsJSON);
    try {
        await XML_1.writeXMLAsync({ path: stringsPath, xml: stringsJSON });
    }
    catch (e) {
        throw new Error(`Error setting name. Cannot write strings.xml to ${stringsPath}.`);
    }
    return true;
}
exports.setName = setName;
function applyName(name, stringsJSON) {
    if (name) {
        return Strings_1.setStringItem([Resources_1.buildResourceItem({ name: 'app_name', value: name })], stringsJSON);
    }
    return Strings_1.removeStringItem('app_name', stringsJSON);
}
//# sourceMappingURL=Name.js.map