"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const XML = __importStar(require("./XML"));
async function writeAndroidManifestAsync(manifestPath, manifest) {
    const manifestXml = XML.format(manifest);
    await fs_extra_1.default.ensureDir(path_1.default.dirname(manifestPath));
    await fs_extra_1.default.writeFile(manifestPath, manifestXml);
}
exports.writeAndroidManifestAsync = writeAndroidManifestAsync;
async function readAndroidManifestAsync(manifestPath) {
    const xml = await XML.readXMLAsync({ path: manifestPath });
    if (!isManifest(xml)) {
        throw new Error('Invalid manifest found at: ' + manifestPath);
    }
    return xml;
}
exports.readAndroidManifestAsync = readAndroidManifestAsync;
function isManifest(xml) {
    // TODO: Maybe more validation
    return !!xml.manifest;
}
function getMainApplication(manifest) {
    var _a, _b, _c;
    return ((_c = (_b = (_a = manifest === null || manifest === void 0 ? void 0 : manifest.manifest) === null || _a === void 0 ? void 0 : _a.application) === null || _b === void 0 ? void 0 : _b.filter(e => { var _a; return ((_a = e === null || e === void 0 ? void 0 : e['$']) === null || _a === void 0 ? void 0 : _a['android:name']) === '.MainApplication'; })[0]) !== null && _c !== void 0 ? _c : null);
}
exports.getMainApplication = getMainApplication;
function getMainActivity(manifest) {
    var _a, _b, _c, _d, _e, _f;
    const mainActivity = (_e = (_d = (_c = (_b = (_a = manifest === null || manifest === void 0 ? void 0 : manifest.manifest) === null || _a === void 0 ? void 0 : _a.application) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.activity) === null || _d === void 0 ? void 0 : _d.filter) === null || _e === void 0 ? void 0 : _e.call(_d, (e) => e['$']['android:name'] === '.MainActivity');
    return (_f = mainActivity === null || mainActivity === void 0 ? void 0 : mainActivity[0]) !== null && _f !== void 0 ? _f : null;
}
exports.getMainActivity = getMainActivity;
function addMetaDataItemToMainApplication(mainApplication, itemName, itemValue) {
    let existingMetaDataItem;
    const newItem = {
        $: {
            'android:name': itemName,
            'android:value': itemValue,
        },
    };
    if (mainApplication.hasOwnProperty('meta-data')) {
        existingMetaDataItem = mainApplication['meta-data'].filter((e) => e['$']['android:name'] === itemName);
        if (existingMetaDataItem.length) {
            existingMetaDataItem[0]['$']['android:value'] = itemValue;
        }
        else {
            mainApplication['meta-data'].push(newItem);
        }
    }
    else {
        mainApplication['meta-data'] = [newItem];
    }
    return mainApplication;
}
exports.addMetaDataItemToMainApplication = addMetaDataItemToMainApplication;
//# sourceMappingURL=Manifest.js.map