"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const xml2js_1 = require("xml2js");
const Manifest_1 = require("./Manifest");
// TODO: make it so intent filters aren't written again if you run the command again
function getIntentFilters(config) {
    var _a, _b;
    return (_b = (_a = config.android) === null || _a === void 0 ? void 0 : _a.intentFilters) !== null && _b !== void 0 ? _b : [];
}
exports.getIntentFilters = getIntentFilters;
async function setAndroidIntentFilters(config, manifestDocument) {
    var _a;
    const intentFilters = getIntentFilters(config);
    if (!intentFilters.length) {
        return manifestDocument;
    }
    const intentFiltersXML = renderIntentFilters(intentFilters).join('');
    const parser = new xml2js_1.Parser();
    const intentFiltersJSON = await parser.parseStringPromise(intentFiltersXML);
    const mainActivity = Manifest_1.getMainActivity(manifestDocument);
    if (mainActivity) {
        mainActivity['intent-filter'] = (_a = mainActivity['intent-filter']) === null || _a === void 0 ? void 0 : _a.concat(intentFiltersJSON['intent-filter']);
    }
    return manifestDocument;
}
exports.setAndroidIntentFilters = setAndroidIntentFilters;
function renderIntentFilters(intentFilters) {
    // returns an array of <intent-filter> tags:
    // [
    //   `<intent-filter>
    //     <data android:scheme="exp"/>
    //     <data android:scheme="exps"/>
    //
    //     <action android:name="android.intent.action.VIEW"/>
    //
    //     <category android:name="android.intent.category.DEFAULT"/>
    //     <category android:name="android.intent.category.BROWSABLE"/>
    //   </intent-filter>`,
    //   ...
    // ]
    return intentFilters.map((intentFilter) => {
        const autoVerify = intentFilter.autoVerify ? ' android:autoVerify="true"' : '';
        return `<intent-filter${autoVerify}>
      ${renderIntentFilterData(intentFilter.data)}
      <action android:name="android.intent.action.${intentFilter.action}"/>
      ${renderIntentFilterCategory(intentFilter.category)}
    </intent-filter>`;
    });
}
exports.default = renderIntentFilters;
function renderIntentFilterDatumEntries(datum) {
    return Object.keys(datum)
        .map(key => `android:${key}="${datum[key]}"`)
        .join(' ');
}
function renderIntentFilterData(data) {
    return (Array.isArray(data) ? data : [data])
        .map(datum => `<data ${renderIntentFilterDatumEntries(datum)}/>`)
        .join('\n');
}
function renderIntentFilterCategory(category) {
    return (Array.isArray(category) ? category : [category])
        .map(cat => `<category android:name="android.intent.category.${cat}"/>`)
        .join('\n');
}
//# sourceMappingURL=IntentFilters.js.map