import { ExpoConfig } from '../Config.types';
export declare function getIcon(config: ExpoConfig): string | null;
export declare function getAdaptiveIcon(config: ExpoConfig): {
    foregroundImage: string | null;
    backgroundColor: string | null;
    backgroundImage: string | null;
};
/**
 * Resizes the user-provided icon to create a set of legacy icon files in
 * their respective "mipmap" directories for <= Android 7, and creates a set of adaptive
 * icon files for > Android 7 from the adaptive icon files (if provided).
 */
export declare function setIconAsync(config: ExpoConfig, projectRoot: string): Promise<true | null>;
/**
 * Configures adaptive icon files to be used on Android 8 and up. A foreground image must be provided,
 * and will have a transparent background unless:
 * - A backgroundImage is provided, or
 * - A backgroundColor was specified
 */
export declare function configureAdaptiveIconAsync(projectRoot: string, foregroundImage: string, backgroundImage: string | null, backgroundColor: string): Promise<void>;
export declare const createAdaptiveIconXmlString: (backgroundImage: string | null) => string;
