"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Manifest_1 = require("./Manifest");
function getGoogleMapsApiKey(config) {
    var _a, _b, _c, _d;
    return (_d = (_c = (_b = (_a = config.android) === null || _a === void 0 ? void 0 : _a.config) === null || _b === void 0 ? void 0 : _b.googleMaps) === null || _c === void 0 ? void 0 : _c.apiKey) !== null && _d !== void 0 ? _d : null;
}
exports.getGoogleMapsApiKey = getGoogleMapsApiKey;
async function setGoogleMapsApiKey(config, manifestDocument) {
    const apiKey = getGoogleMapsApiKey(config);
    if (!apiKey) {
        return manifestDocument;
    }
    let mainApplication = Manifest_1.getMainApplication(manifestDocument);
    if (!mainApplication) {
        mainApplication = { $: { 'android:name': '.MainApplication' } };
    }
    // add meta-data item
    let existingMetaDataItem;
    const metaDataItem = {
        $: {
            'android:name': 'com.google.android.geo.API_KEY',
            'android:value': apiKey,
        },
    };
    if (mainApplication['meta-data']) {
        existingMetaDataItem = mainApplication['meta-data'].filter((e) => e['$']['android:name'] === 'com.google.android.geo.API_KEY');
        if (existingMetaDataItem.length) {
            existingMetaDataItem[0]['$']['android:value'] = apiKey;
        }
        else {
            mainApplication['meta-data'].push(metaDataItem);
        }
    }
    else {
        mainApplication['meta-data'] = [metaDataItem];
    }
    // add uses-library item
    let existingUsesLibraryItem;
    const newUsesLibraryItem = {
        $: {
            'android:name': 'org.apache.http.legacy',
            'android:required': 'false',
        },
    };
    if (mainApplication === null || mainApplication === void 0 ? void 0 : mainApplication['uses-library']) {
        existingUsesLibraryItem = mainApplication['uses-library'].filter((e) => e['$']['android:name'] === 'org.apache.http.legacy');
        if (existingUsesLibraryItem.length) {
            existingUsesLibraryItem[0]['$']['android:required'] = 'false';
        }
        else {
            mainApplication['uses-library'].push(newUsesLibraryItem);
        }
    }
    else {
        mainApplication['uses-library'] = [newUsesLibraryItem];
    }
    return manifestDocument;
}
exports.setGoogleMapsApiKey = setGoogleMapsApiKey;
//# sourceMappingURL=GoogleMapsApiKey.js.map