"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Manifest_1 = require("./Manifest");
function getBranchApiKey(config) {
    var _a, _b, _c, _d;
    return (_d = (_c = (_b = (_a = config.android) === null || _a === void 0 ? void 0 : _a.config) === null || _b === void 0 ? void 0 : _b.branch) === null || _c === void 0 ? void 0 : _c.apiKey) !== null && _d !== void 0 ? _d : null;
}
exports.getBranchApiKey = getBranchApiKey;
async function setBranchApiKey(config, manifestDocument) {
    const apiKey = getBranchApiKey(config);
    if (!apiKey) {
        return manifestDocument;
    }
    let mainApplication = Manifest_1.getMainApplication(manifestDocument);
    let existingBranchApiKeyItem;
    const newBranchApiKeyItem = {
        $: {
            'android:name': 'io.branch.sdk.BranchKey',
            'android:value': apiKey,
        },
    };
    if (mainApplication === null || mainApplication === void 0 ? void 0 : mainApplication['meta-data']) {
        existingBranchApiKeyItem = mainApplication['meta-data'].filter((e) => e['$']['android:name'] === 'io.branch.sdk.BranchKey');
        if (existingBranchApiKeyItem.length) {
            existingBranchApiKeyItem[0]['$']['android:value'] = apiKey;
        }
        else {
            mainApplication['meta-data'].push(newBranchApiKeyItem);
        }
    }
    else {
        if (!mainApplication) {
            mainApplication = { $: { 'android:name': '.MainApplication' } };
        }
        mainApplication['meta-data'] = [newBranchApiKeyItem];
    }
    return manifestDocument;
}
exports.setBranchApiKey = setBranchApiKey;
//# sourceMappingURL=Branch.js.map