"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Manifest_1 = require("./Manifest");
function getAllowBackup(config) {
    var _a, _b;
    // Defaults to true.
    // https://docs.expo.io/versions/latest/config/app/#allowbackup
    return (_b = (_a = config.android) === null || _a === void 0 ? void 0 : _a.allowBackup) !== null && _b !== void 0 ? _b : true;
}
exports.getAllowBackup = getAllowBackup;
async function setAllowBackup(config, manifestDocument) {
    const allowBackup = getAllowBackup(config);
    const mainApplication = Manifest_1.getMainApplication(manifestDocument);
    if (mainApplication === null || mainApplication === void 0 ? void 0 : mainApplication['$']) {
        mainApplication['$']['android:allowBackup'] = String(allowBackup);
    }
    return manifestDocument;
}
exports.setAllowBackup = setAllowBackup;
function getAllowBackupFromManifest(manifestDocument) {
    const mainApplication = Manifest_1.getMainApplication(manifestDocument);
    if (mainApplication === null || mainApplication === void 0 ? void 0 : mainApplication['$']) {
        return mainApplication['$']['android:allowBackup'] === 'true';
    }
    return null;
}
exports.getAllowBackupFromManifest = getAllowBackupFromManifest;
//# sourceMappingURL=AllowBackup.js.map