"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const resolve_from_1 = __importDefault(require("resolve-from"));
const Errors_1 = require("./Errors");
function resolveModule(request, projectRoot, exp) {
    const fromDir = exp.nodeModulesPath ? exp.nodeModulesPath : projectRoot;
    return resolve_from_1.default(fromDir, request);
}
exports.resolveModule = resolveModule;
function projectHasModule(modulePath, projectRoot, exp) {
    const fromDir = exp.nodeModulesPath ? exp.nodeModulesPath : projectRoot;
    return resolve_from_1.default.silent(fromDir, modulePath);
}
exports.projectHasModule = projectHasModule;
function moduleNameFromPath(modulePath) {
    if (modulePath.startsWith('@')) {
        const [org, packageName] = modulePath.split('/');
        if (org && packageName) {
            return [org, packageName].join('/');
        }
        return modulePath;
    }
    const [packageName] = modulePath.split('/');
    return packageName ? packageName : modulePath;
}
exports.moduleNameFromPath = moduleNameFromPath;
async function fileExistsAsync(file) {
    try {
        return (await fs_extra_1.stat(file)).isFile();
    }
    catch (e) {
        return false;
    }
}
exports.fileExistsAsync = fileExistsAsync;
function fileExists(file) {
    try {
        return fs_extra_1.statSync(file).isFile();
    }
    catch (e) {
        return false;
    }
}
exports.fileExists = fileExists;
function getRootPackageJsonPath(projectRoot, exp) {
    const packageJsonPath = 'nodeModulesPath' in exp && typeof exp.nodeModulesPath === 'string'
        ? path_1.join(path_1.resolve(projectRoot, exp.nodeModulesPath), 'package.json')
        : path_1.join(projectRoot, 'package.json');
    if (!fileExists(packageJsonPath)) {
        throw new Errors_1.ConfigError(`The expected package.json path: ${packageJsonPath} does not exist`, 'MODULE_NOT_FOUND');
    }
    return packageJsonPath;
}
exports.getRootPackageJsonPath = getRootPackageJsonPath;
//# sourceMappingURL=Modules.js.map