This document complements the [Packet Analysis](https://emanuele-f.github.io/PCAPdroid/quick_start#14-packet-analysis) section of the user manual to explain how the traffic is managed by PCAPdroid in non-root mode.

PCAPdroid uses the VPNService to capture the network traffic. When the VPNService is active, the traffic is routed to the PCAPdroid app,
which implements a L4 proxy to connect it back to the Internet. The VPNService alone alters the traffic because it uses a different subnet and network interface.
Moreover, what you see in PCAPdroid or in the generated PCAP file is the traffic which goes from the app to the VPNService, but you cannot see the traffic which goes from the VPNService to the Internet.

When the app makes a connection, `saddr1:sport1 -> daddr:dport` (the original), PCAPdroid creates a new connection `saddr2:sport2 -> daddr:dport` (the proxied) which goes over the Internet.
The PCAP generated by PCAPdroid only shows the original connection, but if you capture the data on your router you will capture the proxied connection instead.
The obvious difference between the two is that the source IP address and port are different. Actually, since the L4 proxy works by using L4 sockets, the whole IP and TCP header may also be different (apart from the destination IP address and port, which is the same).

In fact PCAPdroid needs to emulate the TCP features like the TCP window, SEQ and ACK numbers by building fake IP/L4 headers. It does this well enough to trick the app into thinking that it's talking to the remote site, whereas in reality it's talking to the L4 proxy.

```
What app thinks:
  app <-> Internet
 
The reality:
  app <-> PCAPDroid (VPNService) <-> Internet
```

The L4 proxy cannot determine if the data received from the L4 socket was sent as a single packet or multiple packets from the remote site. This is why you cannot reliably use the generated PCAP to perform per-packet analysis.
