# Metro Hermes Compiler

This experimental module provides a high-level API to work with the Hermes bytecode compiler (HBC). HBC is integrated as a WASM binary generated by the emscripten toolchain and checked in as part of this package.

## How to build HBC

A pre-configured emscripten environment can be used through this [Docker image](https://hub.docker.com/r/trzeci/emscripten/). Docker can be installed via its [desktop app](https://docs.docker.com/docker-for-mac/). Make sure to increase resource limits (16G RAM, as much CPU as possible).

```
cd path/to/hermes/checkout
docker run -i -t --rm -v `pwd`:`pwd` trzeci/emscripten bash
apt-get update -y && apt-get install -y icu-devtools
cd path/to/hermes/checkout
cmake . -DCMAKE_TOOLCHAIN_FILE=/emsdk_portable/emscripten/sdk/cmake/Modules/Platform/Emscripten.cmake -DCMAKE_BUILD_TYPE=Release
make -j emhermesc
```

After the build process finishes the Hermes Bytecode Compiler JavaScript file will be available in the `bin` folder.
