"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _HermesASTAdapter2 = _interopRequireDefault(require("./HermesASTAdapter"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var HermesToESTreeAdapter = /*#__PURE__*/function (_HermesASTAdapter) {
  _inherits(HermesToESTreeAdapter, _HermesASTAdapter);

  var _super = _createSuper(HermesToESTreeAdapter);

  function HermesToESTreeAdapter(options, code) {
    var _this;

    _classCallCheck(this, HermesToESTreeAdapter);

    _this = _super.call(this, options);

    _defineProperty(_assertThisInitialized(_this), "code", void 0);

    _this.code = code;
    return _this;
  }

  _createClass(HermesToESTreeAdapter, [{
    key: "fixSourceLocation",
    value: function fixSourceLocation(node) {
      var _this$sourceFilename;

      var loc = node.loc;

      if (loc == null) {
        return;
      }

      node.loc = {
        source: (_this$sourceFilename = this.sourceFilename) !== null && _this$sourceFilename !== void 0 ? _this$sourceFilename : null,
        start: loc.start,
        end: loc.end
      };
      node.range = [loc.rangeStart, loc.rangeEnd];
    }
  }, {
    key: "mapNode",
    value: function mapNode(node) {
      this.fixSourceLocation(node);

      switch (node.type) {
        case 'Program':
          return this.mapProgram(node);

        case 'NullLiteral':
          return this.mapNullLiteral(node);

        case 'BooleanLiteral':
        case 'StringLiteral':
        case 'NumericLiteral':
          return this.mapSimpleLiteral(node);

        case 'RegExpLiteral':
          return this.mapRegExpLiteral(node);

        case 'Empty':
          return this.mapEmpty(node);

        case 'TemplateElement':
          return this.mapTemplateElement(node);

        case 'GenericTypeAnnotation':
          return this.mapGenericTypeAnnotation(node);

        case 'ImportDeclaration':
          return this.mapImportDeclaration(node);

        case 'ImportSpecifier':
          return this.mapImportSpecifier(node);

        case 'ExportDefaultDeclaration':
          return this.mapExportDefaultDeclaration(node);

        case 'ExportNamedDeclaration':
          return this.mapExportNamedDeclaration(node);

        case 'ExportAllDeclaration':
          return this.mapExportAllDeclaration(node);

        case 'PrivateName':
        case 'ClassPrivateProperty':
          return this.mapPrivateProperty(node);

        default:
          return this.mapNodeDefault(node);
      }
    }
  }, {
    key: "mapProgram",
    value: function mapProgram(node) {
      node = this.mapNodeDefault(node);
      node.sourceType = this.getSourceType();
      return node;
    }
  }, {
    key: "mapSimpleLiteral",
    value: function mapSimpleLiteral(node) {
      node.type = 'Literal';
      node.raw = this.code.slice(node.range[0], node.range[1]);
      return node;
    }
  }, {
    key: "mapNullLiteral",
    value: function mapNullLiteral(node) {
      node.type = 'Literal';
      node.value = null;
      node.raw = this.code.slice(node.range[0], node.range[1]);
      return node;
    }
  }, {
    key: "mapRegExpLiteral",
    value: function mapRegExpLiteral(node) {
      var pattern = node.pattern,
          flags = node.flags; // Create RegExp value if possible. This can fail when the flags are invalid.

      var value;

      try {
        value = new RegExp(pattern, flags);
      } catch (e) {
        value = null;
      }

      return {
        type: 'Literal',
        loc: node.loc,
        range: node.range,
        value: value,
        raw: this.code.slice(node.range[0], node.range[1]),
        regex: {
          pattern: pattern,
          flags: flags
        }
      };
    }
  }, {
    key: "mapTemplateElement",
    value: function mapTemplateElement(node) {
      return {
        type: 'TemplateElement',
        loc: node.loc,
        range: node.range,
        tail: node.tail,
        value: {
          cooked: node.cooked,
          raw: node.raw
        }
      };
    }
  }, {
    key: "mapGenericTypeAnnotation",
    value: function mapGenericTypeAnnotation(node) {
      // Convert simple `this` generic type to ThisTypeAnnotation
      if (node.typeParameters === null && node.id.type === 'Identifier' && node.id.name === 'this') {
        return {
          type: 'ThisTypeAnnotation',
          loc: node.loc,
          range: node.range
        };
      }

      return this.mapNodeDefault(node);
    }
  }, {
    key: "mapComment",
    value: function mapComment(node) {
      if (node.type === 'CommentBlock') {
        node.type = 'Block';
      } else if (node.type === 'CommentLine') {
        node.type = 'Line';
      }

      return node;
    }
  }]);

  return HermesToESTreeAdapter;
}(_HermesASTAdapter2["default"]);

exports["default"] = HermesToESTreeAdapter;