"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function bufFromString(str) {
    var length = Buffer.byteLength(str);
    var buffer = Buffer.allocUnsafe
        ? Buffer.allocUnsafe(length)
        : new Buffer(length);
    buffer.write(str);
    return buffer;
}
exports.bufFromString = bufFromString;
function emptyBuffer() {
    var buffer = Buffer.allocUnsafe
        ? Buffer.allocUnsafe(0)
        : new Buffer(0);
    return buffer;
}
exports.emptyBuffer = emptyBuffer;
function filterArray(arr, filter) {
    var rtn = [];
    for (var i = 0; i < arr.length; i++) {
        if (filter.indexOf(i) > -1) {
            rtn.push(arr[i]);
        }
    }
    return rtn;
}
exports.filterArray = filterArray;
exports.trimLeft = String.prototype.trimLeft ? function trimLeftNative(str) {
    return str.trimLeft();
} : function trimLeftRegExp(str) {
    return str.replace(/^\s+/, "");
};
exports.trimRight = String.prototype.trimRight ? function trimRightNative(str) {
    return str.trimRight();
} : function trimRightRegExp(str) {
    return str.replace(/\s+$/, "");
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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