"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueriesForElement = void 0;
exports.within = within;
var _text = require("./queries/text");
var _testId = require("./queries/testId");
var _displayValue = require("./queries/displayValue");
var _placeholderText = require("./queries/placeholderText");
var _labelText = require("./queries/labelText");
var _hintText = require("./queries/hintText");
var _role = require("./queries/role");
var _a11yState = require("./queries/a11yState");
var _a11yValue = require("./queries/a11yValue");
var _unsafeType = require("./queries/unsafeType");
var _unsafeProps = require("./queries/unsafeProps");
function within(instance) {
  return {
    ...(0, _text.bindByTextQueries)(instance),
    ...(0, _testId.bindByTestIdQueries)(instance),
    ...(0, _displayValue.bindByDisplayValueQueries)(instance),
    ...(0, _placeholderText.bindByPlaceholderTextQueries)(instance),
    ...(0, _labelText.bindByLabelTextQueries)(instance),
    ...(0, _hintText.bindByHintTextQueries)(instance),
    ...(0, _role.bindByRoleQueries)(instance),
    ...(0, _a11yState.bindByA11yStateQueries)(instance),
    ...(0, _a11yValue.bindByA11yValueQueries)(instance),
    ...(0, _unsafeType.bindUnsafeByTypeQueries)(instance),
    ...(0, _unsafeProps.bindUnsafeByPropsQueries)(instance)
  };
}
const getQueriesForElement = within;
exports.getQueriesForElement = getQueriesForElement;
//# sourceMappingURL=within.js.map