/// <reference types="react" />
import { ReactTestInstance } from 'react-test-renderer';
/**
 * Checks if the given element is a host element.
 * @param element The element to check.
 */
export declare function isHostElement(element?: ReactTestInstance | null): boolean;
/**
 * Returns first host ancestor for given element.
 * @param element The element start traversing from.
 */
export declare function getHostParent(element: ReactTestInstance | null): ReactTestInstance | null;
/**
 * Returns host children for given element.
 * @param element The element start traversing from.
 */
export declare function getHostChildren(element: ReactTestInstance | null): ReactTestInstance[];
/**
 * Return a single host element that represent the passed host or composite element.
 *
 * @param element The element start traversing from.
 * @throws Error if the passed element is a composite element and has no host children or has more than one host child.
 * @returns If the passed element is a host element, it will return itself, if the passed element is a composite
 * element, it will return a single host descendant.
 */
export declare function getHostSelf(element: ReactTestInstance | null): ReactTestInstance;
/**
 * Return the array of host elements that represent the passed element.
 *
 * @param element The element start traversing from.
 * @returns If the passed element is a host element, it will return an array containing only that element,
 * if the passed element is a composite element, it will return an array containing its host children (zero, one or many).
 */
export declare function getHostSelves(element: ReactTestInstance | null): ReactTestInstance[];
/**
 * Returns host siblings for given element.
 * @param element The element start traversing from.
 */
export declare function getHostSiblings(element: ReactTestInstance | null): ReactTestInstance[];
export declare function getCompositeParentOfType(element: ReactTestInstance, type: React.ComponentType): ReactTestInstance | null;
/**
 * Note: this function should be generally used for core React Native types like `View`, `Text`, `TextInput`, etc.
 */
export declare function isHostElementForType(element: ReactTestInstance, type: React.ComponentType): boolean;
