import Overlay from './components/Overlay';
import Sheet from './components/Sheet';
import Button from './components/Button';
import ShareSheet from './components/ShareSheet';
import { Social, IsPackageInstalledResult, ActivityType, ShareOpenResult, ShareAsset, ShareOptions, ShareSingleOptions, ShareSingleResult } from './types';
declare const RNShare: {
    readonly Button: ({ buttonStyle, onPress, iconSrc, textStyle, children }: import("./components/Button").ButtonProps) => JSX.Element;
    readonly ShareSheet: typeof ShareSheet;
    readonly Overlay: typeof Overlay;
    readonly Sheet: typeof Sheet;
    readonly Social: {
        readonly FACEBOOK: Social.Facebook;
        readonly FACEBOOK_STORIES: Social.FacebookStories;
        readonly PAGESMANAGER: Social.Pagesmanager;
        readonly TWITTER: Social.Twitter;
        readonly WHATSAPP: Social.Whatsapp;
        readonly WHATSAPPBUSINESS: Social.Whatsappbusiness;
        readonly INSTAGRAM: Social.Instagram;
        readonly INSTAGRAM_STORIES: Social.InstagramStories;
        readonly GOOGLEPLUS: Social.Googleplus;
        readonly EMAIL: Social.Email;
        readonly PINTEREST: Social.Pinterest;
        readonly LINKEDIN: Social.Linkedin;
        readonly SMS: Social.Sms;
        readonly TELEGRAM: Social.Telegram;
        readonly MESSENGER: Social.Messenger;
        readonly SNAPCHAT: Social.Snapchat;
        readonly VIBER: Social.Viber;
    };
    readonly open: (options: ShareOptions) => Promise<ShareOpenResult | never>;
    readonly shareSingle: (options: ShareSingleOptions) => Promise<ShareSingleResult | never>;
    readonly isPackageInstalled: (packageName: string) => Promise<IsPackageInstalledResult | never>;
};
export { Overlay, Sheet, Button, ShareSheet, ShareAsset, Social };
export type { ShareSingleOptions, ShareOptions, ActivityType, IsPackageInstalledResult };
export type { OverlayProps } from './components/Overlay';
export type { SheetProps } from './components/Sheet';
export type { ButtonProps } from './components/Button';
export type { ShareSheetProps } from './components/ShareSheet';
export default RNShare;
