/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
"use strict";

const canonicalize = require("metro-core/src/canonicalize");

function getGraphId(
  entryFile,
  options,
  { shallow, experimentalImportBundleSupport }
) {
  return JSON.stringify(
    {
      entryFile,
      options: {
        customTransformOptions:
          options.customTransformOptions != null
            ? options.customTransformOptions
            : null,
        dev: options.dev,
        experimentalImportSupport: options.experimentalImportSupport || false,
        hot: options.hot,
        minify: options.minify,
        unstable_disableES6Transforms: options.unstable_disableES6Transforms,
        platform: options.platform != null ? options.platform : null,
        runtimeBytecodeVersion: options.runtimeBytecodeVersion,
        type: options.type,
        experimentalImportBundleSupport,
        shallow,
        unstable_transformProfile:
          options.unstable_transformProfile || "default",
      },
    },
    canonicalize
  );
}

module.exports = getGraphId;
