"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.accessiblityValueKeys = exports.accessibilityStateKeys = void 0;
exports.isAccessibilityElement = isAccessibilityElement;
exports.isHiddenFromAccessibility = isHiddenFromAccessibility;
exports.isInaccessible = void 0;
var _reactNative = require("react-native");
var _componentTree = require("./component-tree");
const accessibilityStateKeys = ['disabled', 'selected', 'checked', 'busy', 'expanded'];
exports.accessibilityStateKeys = accessibilityStateKeys;
const accessiblityValueKeys = ['min', 'max', 'now', 'text'];
exports.accessiblityValueKeys = accessiblityValueKeys;
function isHiddenFromAccessibility(element, {
  cache
} = {}) {
  if (element == null) {
    return true;
  }
  let current = element;
  while (current) {
    let isCurrentSubtreeInaccessible = cache?.get(current);
    if (isCurrentSubtreeInaccessible === undefined) {
      isCurrentSubtreeInaccessible = isSubtreeInaccessible(current);
      cache?.set(current, isCurrentSubtreeInaccessible);
    }
    if (isCurrentSubtreeInaccessible) {
      return true;
    }
    current = current.parent;
  }
  return false;
}

/** RTL-compatitibility alias for `isHiddenFromAccessibility` */
const isInaccessible = isHiddenFromAccessibility;
exports.isInaccessible = isInaccessible;
function isSubtreeInaccessible(element) {
  // iOS: accessibilityElementsHidden
  // See: https://reactnative.dev/docs/accessibility#accessibilityelementshidden-ios
  if (element.props.accessibilityElementsHidden) {
    return true;
  }

  // Android: importantForAccessibility
  // See: https://reactnative.dev/docs/accessibility#importantforaccessibility-android
  if (element.props.importantForAccessibility === 'no-hide-descendants') {
    return true;
  }

  // Note that `opacity: 0` is not treated as inaccessible on iOS
  const flatStyle = _reactNative.StyleSheet.flatten(element.props.style) ?? {};
  if (flatStyle.display === 'none') return true;

  // iOS: accessibilityViewIsModal
  // See: https://reactnative.dev/docs/accessibility#accessibilityviewismodal-ios
  const hostSiblings = (0, _componentTree.getHostSiblings)(element);
  if (hostSiblings.some(sibling => sibling.props.accessibilityViewIsModal)) {
    return true;
  }
  return false;
}
function isAccessibilityElement(element) {
  if (element == null) {
    return false;
  }
  if (element.props.accessible !== undefined) {
    return element.props.accessible;
  }
  return (0, _componentTree.isHostElementForType)(element, _reactNative.Text) || (0, _componentTree.isHostElementForType)(element, _reactNative.TextInput) || (0, _componentTree.isHostElementForType)(element, _reactNative.Switch);
}
//# sourceMappingURL=accessiblity.js.map