import { DebugOptions } from './helpers/debugDeep';
/**
 * Global configuration options for React Native Testing Library.
 */
export type Config = {
    /** Default timeout, in ms, for `waitFor` and `findBy*` queries. */
    asyncUtilTimeout: number;
    /** Default value for `includeHiddenElements` query option. */
    defaultIncludeHiddenElements: boolean;
    /** Default options for `debug` helper. */
    defaultDebugOptions?: Partial<DebugOptions>;
};
export type ConfigAliasOptions = {
    /** RTL-compatibility alias to `defaultIncludeHiddenElements` */
    defaultHidden: boolean;
};
export type HostComponentNames = {
    text: string;
    textInput: string;
};
export type InternalConfig = Config & {
    /** Whether to use breaking changes intended for next major version release. */
    useBreakingChanges: boolean;
    /** Names for key React Native host components. */
    hostComponentNames?: HostComponentNames;
};
/**
 * Configure global options for React Native Testing Library.
 */
export declare function configure(options: Partial<Config & ConfigAliasOptions>): void;
export declare function configureInternal(option: Partial<InternalConfig>): void;
export declare function resetToDefaults(): void;
export declare function getConfig(): {
    /** Default timeout, in ms, for `waitFor` and `findBy*` queries. */
    asyncUtilTimeout: number;
    /** Default value for `includeHiddenElements` query option. */
    defaultIncludeHiddenElements: boolean;
    /** Default options for `debug` helper. */
    defaultDebugOptions?: Partial<DebugOptions> | undefined;
    /** Whether to use breaking changes intended for next major version release. */
    useBreakingChanges: boolean;
    /** Names for key React Native host components. */
    hostComponentNames?: HostComponentNames | undefined;
};
