var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toHaveStyle = toHaveStyle;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _reactNative = require("react-native");

var _jestMatcherUtils = require("jest-matcher-utils");

var _jestDiff = require("jest-diff");

var _chalk = _interopRequireDefault(require("chalk"));

var _utils = require("./utils");

function printoutStyles(styles) {
  return Object.keys(styles).sort().map(function (prop) {
    return Array.isArray(styles[prop]) ? prop + ": " + JSON.stringify(styles[prop], null, 2) + ";" : prop + ": " + styles[prop] + ";";
  }).join('\n');
}

function narrow(expected, received) {
  return Object.keys(received).filter(function (prop) {
    return expected[prop];
  }).reduce(function (obj, prop) {
    return Object.assign(obj, (0, _defineProperty2.default)({}, prop, received[prop]));
  }, {});
}

function expectedDiff(expected, elementStyles) {
  var received = narrow(expected, elementStyles);
  var diffOutput = (0, _jestDiff.diff)(printoutStyles(expected), printoutStyles(received));
  return diffOutput.replace(_chalk.default.red('+ Received') + "\n", '');
}

function toHaveStyle(element, style) {
  var _element$props$style,
      _this = this;

  (0, _utils.checkReactElement)(element, toHaveStyle, this);
  var elementStyle = (_element$props$style = element.props.style) != null ? _element$props$style : {};
  var expected = Array.isArray(style) ? _reactNative.StyleSheet.flatten(style) : style;
  var received = Array.isArray(elementStyle) ? _reactNative.StyleSheet.flatten(elementStyle) : elementStyle;
  return {
    pass: Object.entries(expected).every(function (_ref) {
      var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
          prop = _ref2[0],
          value = _ref2[1];

      return _this.equals(received == null ? void 0 : received[prop], value);
    }),
    message: function message() {
      var matcher = (_this.isNot ? '.not' : '') + ".toHaveStyle";
      return [(0, _jestMatcherUtils.matcherHint)(matcher, 'element', ''), expectedDiff(expected, received)].join('\n\n');
    }
  };
}