Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toContainElement = toContainElement;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function toContainElement(container, element) {
  var _this = this;

  (0, _utils.checkReactElement)(container, toContainElement, this);

  if (element !== null) {
    (0, _utils.checkReactElement)(element, toContainElement, this);
  }

  var matches = [];

  if (element) {
    matches = container.findAll(function (node) {
      return node.type === element.type && _this.equals(node.props, element.props);
    });
  }

  return {
    pass: Boolean(matches.length),
    message: function message() {
      return [(0, _jestMatcherUtils.matcherHint)((_this.isNot ? '.not' : '') + ".toContainElement", 'element', 'element'), '', (0, _jestMatcherUtils.RECEIVED_COLOR)((0, _utils.printElement)(container) + " " + (_this.isNot ? '\n\ncontains:\n\n' : '\n\ndoes not contain:\n\n') + " " + (0, _utils.printElement)(element) + "\n        ")].join('\n');
    }
  };
}