Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toBeEmpty = toBeEmpty;
exports.toBeEmptyElement = toBeEmptyElement;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function toBeEmptyElement(element) {
  var _element$props,
      _this = this;

  (0, _utils.checkReactElement)(element, toBeEmptyElement, this);
  return {
    pass: (0, _utils.isEmpty)(element == null ? void 0 : (_element$props = element.props) == null ? void 0 : _element$props.children),
    message: function message() {
      return [(0, _jestMatcherUtils.matcherHint)((_this.isNot ? '.not' : '') + ".toBeEmpty", 'element', ''), '', 'Received:', (0, _utils.printElement)(element)].join('\n');
    }
  };
}

function toBeEmpty(element) {
  (0, _utils.printDeprecationWarning)('toBeEmpty', "\"toBeEmpty()\" matcher has been renamed to \"toBeEmptyElement()\". Old name will be deleted in future versions of @testing-library/jest-native.");
  return toBeEmptyElement(element);
}