Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toBeDisabled = toBeDisabled;
exports.toBeEnabled = toBeEnabled;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

var DISABLE_TYPES = ['Button', 'Slider', 'Switch', 'Text', 'TouchableHighlight', 'TouchableOpacity', 'TouchableWithoutFeedback', 'TouchableNativeFeedback', 'View', 'TextInput', 'Pressable'];

function isElementDisabledByParent(parent) {
  return isElementDisabled(parent);
}

function isElementDisabled(element) {
  var _element$props, _element$props2, _element$props2$acces, _element$props3, _element$props3$acces;

  if (!DISABLE_TYPES.includes((0, _utils.getType)(element))) return false;
  return !!(element != null && (_element$props = element.props) != null && _element$props.disabled) || !!(element != null && (_element$props2 = element.props) != null && (_element$props2$acces = _element$props2.accessibilityState) != null && _element$props2$acces.disabled) || !!(element != null && (_element$props3 = element.props) != null && (_element$props3$acces = _element$props3.accessibilityStates) != null && _element$props3$acces.includes('disabled'));
}

function isAncestorDisabled(element) {
  var parent = element.parent;
  return Boolean(parent) && (isElementDisabledByParent(element, parent) || isAncestorDisabled(parent));
}

function toBeDisabled(element) {
  var _this = this;

  (0, _utils.checkReactElement)(element, toBeDisabled, this);
  var isDisabled = isElementDisabled(element) || isAncestorDisabled(element);
  return {
    pass: isDisabled,
    message: function message() {
      var is = isDisabled ? 'is' : 'is not';
      return [(0, _jestMatcherUtils.matcherHint)((_this.isNot ? '.not' : '') + ".toBeDisabled", 'element', ''), '', "Received element " + is + " disabled:", (0, _utils.printElement)(element)].join('\n');
    }
  };
}

function toBeEnabled(element) {
  var _this2 = this;

  (0, _utils.checkReactElement)(element, toBeDisabled, this);
  var isEnabled = !isElementDisabled(element);
  return {
    pass: isEnabled,
    message: function message() {
      var is = isEnabled ? 'is' : 'is not';
      return [(0, _jestMatcherUtils.matcherHint)((_this2.isNot ? '.not' : '') + ".toBeEnabled", 'element', ''), '', "Received element " + is + " enabled:", (0, _utils.printElement)(element)].join('\n');
    }
  };
}