"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindByTextQueries = void 0;
var _reactNative = require("react-native");
var _config = require("../config");
var _componentTree = require("../helpers/component-tree");
var _filterNodeByType = require("../helpers/filterNodeByType");
var _findAll = require("../helpers/findAll");
var _hostComponentNames = require("../helpers/host-component-names");
var _matchTextContent = require("../helpers/matchers/matchTextContent");
var _makeQueries = require("./makeQueries");
const queryAllByText = instance => function queryAllByTextFn(text, options = {}) {
  const shouldReturnHostText = (0, _config.getConfig)().useBreakingChanges;

  // Legacy version: return composite Text
  if (!shouldReturnHostText) {
    const baseInstance = (0, _componentTree.isHostElementForType)(instance, _reactNative.Text) ? (0, _componentTree.getCompositeParentOfType)(instance, _reactNative.Text) : instance;
    if (!baseInstance) {
      return [];
    }
    const results = (0, _findAll.findAll)(baseInstance, node => (0, _filterNodeByType.filterNodeByType)(node, _reactNative.Text) && (0, _matchTextContent.matchTextContent)(node, text, options), {
      ...options,
      matchDeepestOnly: true
    });
    return results;
  }

  // vNext version: returns host Text
  return (0, _findAll.findAll)(instance, node => (0, _filterNodeByType.filterNodeByType)(node, (0, _hostComponentNames.getHostComponentNames)().text) && (0, _matchTextContent.matchTextContent)(node, text, options), {
    ...options,
    matchDeepestOnly: true
  });
};
const getMultipleError = text => `Found multiple elements with text: ${String(text)}`;
const getMissingError = text => `Unable to find an element with text: ${String(text)}`;
const {
  getBy,
  getAllBy,
  queryBy,
  queryAllBy,
  findBy,
  findAllBy
} = (0, _makeQueries.makeQueries)(queryAllByText, getMissingError, getMultipleError);
const bindByTextQueries = instance => ({
  getByText: getBy(instance),
  getAllByText: getAllBy(instance),
  queryByText: queryBy(instance),
  queryAllByText: queryAllBy(instance),
  findByText: findBy(instance),
  findAllByText: findAllBy(instance)
});
exports.bindByTextQueries = bindByTextQueries;
//# sourceMappingURL=text.js.map