"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configureHostComponentNamesIfNeeded = configureHostComponentNamesIfNeeded;
exports.getHostComponentNames = getHostComponentNames;
var _react = _interopRequireDefault(require("react"));
var _reactNative = require("react-native");
var _reactTestRenderer = _interopRequireDefault(require("react-test-renderer"));
var _config = require("../config");
var _within = require("../within");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const userConfigErrorMessage = `There seems to be an issue with your configuration that prevents React Native Testing Library from working correctly.
Please check if you are using compatible versions of React Native and React Native Testing Library.`;
function getHostComponentNames() {
  let hostComponentNames = (0, _config.getConfig)().hostComponentNames;
  if (!hostComponentNames) {
    hostComponentNames = detectHostComponentNames();
    (0, _config.configureInternal)({
      hostComponentNames
    });
  }
  return hostComponentNames;
}
function configureHostComponentNamesIfNeeded() {
  const configHostComponentNames = (0, _config.getConfig)().hostComponentNames;
  if (configHostComponentNames) {
    return;
  }
  const hostComponentNames = detectHostComponentNames();
  (0, _config.configureInternal)({
    hostComponentNames
  });
}
function detectHostComponentNames() {
  try {
    const renderer = _reactTestRenderer.default.create( /*#__PURE__*/_react.default.createElement(_reactNative.View, null, /*#__PURE__*/_react.default.createElement(_reactNative.Text, {
      testID: "text"
    }, "Hello"), /*#__PURE__*/_react.default.createElement(_reactNative.TextInput, {
      testID: "textInput"
    })));
    const {
      getByTestId
    } = (0, _within.getQueriesForElement)(renderer.root);
    const textHostName = getByTestId('text').type;
    const textInputHostName = getByTestId('textInput').type;

    // This code path should not happen as getByTestId always returns host elements.
    if (typeof textHostName !== 'string' || typeof textInputHostName !== 'string') {
      throw new Error('getByTestId returned non-host component');
    }
    return {
      text: textHostName,
      textInput: textInputHostName
    };
  } catch (error) {
    const errorMessage = error && typeof error === 'object' && 'message' in error ? error.message : null;
    throw new Error(`Trying to detect host component names triggered the following error:\n\n${errorMessage}\n\n${userConfigErrorMessage}`);
  }
}
//# sourceMappingURL=host-component-names.js.map