import { AccessibilityState, AccessibilityValue } from 'react-native';
import { ReactTestInstance } from 'react-test-renderer';
type IsInaccessibleOptions = {
    cache?: WeakMap<ReactTestInstance, boolean>;
};
export declare const accessibilityStateKeys: (keyof AccessibilityState)[];
export declare const accessiblityValueKeys: (keyof AccessibilityValue)[];
export declare function isHiddenFromAccessibility(element: ReactTestInstance | null, { cache }?: IsInaccessibleOptions): boolean;
/** RTL-compatitibility alias for `isHiddenFromAccessibility` */
export declare const isInaccessible: typeof isHiddenFromAccessibility;
export declare function isAccessibilityElement(element: ReactTestInstance | null): boolean;
export {};
