package com.dozingcatsoftware.vectorcamera

enum class CameraStatus {
    CLOSED,
    OPENING,
    OPENED,
    CAPTURE_STARTING,
    CAPTURE_READY,
    CAPTURING_PREVIEW,
    CAPTURING_PHOTO,
    CAPTURING_VIDEO,
    STOPPING_CAPTURE,
    RESTARTING_CAPTURE,
    CLOSING,
    ERROR,
    ;

    fun isCapturing(): Boolean {
        return this == CAPTURING_PREVIEW || this == CAPTURING_PHOTO ||
                this == CAPTURING_VIDEO
    }

    fun isSavingImage(): Boolean {
        return this == CAPTURING_PHOTO || this == CAPTURING_VIDEO
    }
}
