Comments or bug reports: [bnenning@gmail.com](mailto:bnenning@gmail.com)

## Basic Rules

Each player starts with half of the cards, and the object is to win all of them. Play consists of a
series of rounds, in which players play cards in a central pile until one player wins the round and
takes the cards in the pile.

In each round, players take turns playing a single card to the pile until one player plays a face
card or ace. At this point the other player has a number of chances to also play a face card or ace:
4 chances for an ace, 3 chances for a king, 2 for a queen, and 1 for a jack. If the other player
fails to play a face card or ace in that number of chances, the first player wins the round and
takes the cards in the pile. If they do play a face card or ace, then their opponent similarly
has a number of chances to play a face card or ace. This continues until one player fails to play a
face card or ace in the designated number of chances, at which point their opponent takes the cards
in the pile and starts the next round.

The game is over when one player has won all the cards. If a player runs out of cards in the middle
of a round, the other player continues playing for both until the round is over. The player without
cards can win the round and stay in the game by slapping the pile as described below.

## Slapping

If two cards of the same rank are played consecutively, either player may slap the pile to
immediately win the round and take the cards. (Touch or click the pile to slap it). The pile can be
slapped even if a player is "out of chances" to respond to an opponent's face card. For example, if
Bob plays a queen, and Alice then plays the 3 of hearts followed by the 3 of spades, Alice can slap
the pile to win it.

Note that in human vs human games, players should touch the pile in a location closer to their side
of the screen. This is how the app determines which player slapped.

## Rule Variations

Selecting "Preferences" from the main menu allows you to play with optional rules.
- **Tens are stoppers**: If enabled, when one player plays a face card or ace and the other player
plays a ten, that "stops" the threat and players return to alternately playing single cards.
- **Slap on sandwiches**: If enabled, players can slap the pile when a "sandwich" occurs, which is
two cards of the same rank with another card between them; for example 6-3-6.
- **Slap on run of 3**: If enabled, players can slap the pile when 3 consecutive cards of increasing
or decreasing rank are played, for example 8-7-6 or 9-10-jack. Aces can be high or low and can
"wrap around", so players can slap on king-ace-2.
- **Slap on 4 of same suit**: If enabled, players can slap the pile when 4 cards of the same suit
are played.
- **Slap on adds to 10**: If enabled, players can slap the pile when the last two cards add to 10,
for example a 7 and a 3. Face cards and aces don't trigger this rule.
- **Slap on marriages**: If enabled, players can slap the pile when a "marriage" occurs, which is
when a king and queen are played consecutively.
- **Slap on divorces**: If enabled, players can slap the pile when a "divorce" occurs, which is
when a king and queen are played with another card between them.
- **Penalty for wrong slap**: Allows you to choose the penalty if a player slaps incorrectly.
"Penalty card" causes the offending player to put a card on the bottom of the current pile.
"Can't slap for next 5 cards" prevents the player from slapping until 5 additional cards are played.

## License

This application is released under the GNU General Public License, version 3. Source code is
available [here](https://github.com/dozingcat/MousePounce).

## Credits

- Cats and paws by [AnnaliseArt on Pixabay](https://pixabay.com/illustrations/cats-hanging-cats-kitty-cat-paw-3611310/)
- Thought bubble by [OpenClipart-Vectors on Pixabay](https://pixabay.com/vectors/balloon-bubble-speech-thought-150981/)
- "No" symbol by [OpenClipart-Vectors on Pixabay](https://pixabay.com/vectors/unauthorised-denied-ban-prohibition-156169/)
- Cat emojis from [Noto Emoji by Google](https://github.com/googlefonts/noto-emoji/)
- [Playing card images](https://code.google.com/archive/p/vector-playing-cards/)
- Sounds by Boojie, Ginger, and Sauerkraut