package com.dede.android_eggs.views.theme

import androidx.annotation.FloatRange
import androidx.compose.ui.graphics.Color
import androidx.core.graphics.ColorUtils

val primaryLight = Color(0xFF2D6A44)
val onPrimaryLight = Color(0xFFFFFFFF)
val primaryContainerLight = Color(0xFFB1F1C2)
val onPrimaryContainerLight = Color(0xFF00210E)
val secondaryLight = Color(0xFF4F6353)
val onSecondaryLight = Color(0xFFFFFFFF)
val secondaryContainerLight = Color(0xFFD2E8D4)
val onSecondaryContainerLight = Color(0xFF0D1F13)
val tertiaryLight = Color(0xFF3A646F)
val onTertiaryLight = Color(0xFFFFFFFF)
val tertiaryContainerLight = Color(0xFFBEEAF7)
val onTertiaryContainerLight = Color(0xFF001F26)
val errorLight = Color(0xFFBA1A1A)
val onErrorLight = Color(0xFFFFFFFF)
val errorContainerLight = Color(0xFFFFDAD6)
val onErrorContainerLight = Color(0xFF410002)
val backgroundLight = Color(0xFFF6FBF3)
val onBackgroundLight = Color(0xFF181D18)
val surfaceLight = Color(0xFFF6FBF3)
val onSurfaceLight = Color(0xFF181D18)
val surfaceVariantLight = Color(0xFFDDE5DB)
val onSurfaceVariantLight = Color(0xFF414942)
val outlineLight = Color(0xFF717971)
val outlineVariantLight = Color(0xFFC0C9BF)
val scrimLight = Color(0xFF000000)
val inverseSurfaceLight = Color(0xFF2C322D)
val inverseOnSurfaceLight = Color(0xFFEDF2EB)
val inversePrimaryLight = Color(0xFF95D5A7)
val surfaceDimLight = Color(0xFFD6DBD4)
val surfaceBrightLight = Color(0xFFF6FBF3)
val surfaceContainerLowestLight = Color(0xFFFFFFFF)
val surfaceContainerLowLight = Color(0xFFF0F5ED)
val surfaceContainerLight = Color(0xFFEAEFE8)
val surfaceContainerHighLight = Color(0xFFE5EAE2)
val surfaceContainerHighestLight = Color(0xFFDFE4DD)

val primaryDark = Color(0xFF95D5A7)
val onPrimaryDark = Color(0xFF00391D)
val primaryContainerDark = Color(0xFF10512E)
val onPrimaryContainerDark = Color(0xFFB1F1C2)
val secondaryDark = Color(0xFFB6CCB9)
val onSecondaryDark = Color(0xFF223527)
val secondaryContainerDark = Color(0xFF384B3D)
val onSecondaryContainerDark = Color(0xFFD2E8D4)
val tertiaryDark = Color(0xFFA2CDDA)
val onTertiaryDark = Color(0xFF023640)
val tertiaryContainerDark = Color(0xFF214C57)
val onTertiaryContainerDark = Color(0xFFBEEAF7)
val errorDark = Color(0xFFFFB4AB)
val onErrorDark = Color(0xFF690005)
val errorContainerDark = Color(0xFF93000A)
val onErrorContainerDark = Color(0xFFFFDAD6)
val backgroundDark = Color(0xFF101510)
val onBackgroundDark = Color(0xFFDFE4DD)
val surfaceDark = Color(0xFF101510)
val onSurfaceDark = Color(0xFFDFE4DD)
val surfaceVariantDark = Color(0xFF414942)
val onSurfaceVariantDark = Color(0xFFC0C9BF)
val outlineDark = Color(0xFF8B938A)
val outlineVariantDark = Color(0xFF414942)
val scrimDark = Color(0xFF000000)
val inverseSurfaceDark = Color(0xFFDFE4DD)
val inverseOnSurfaceDark = Color(0xFF2C322D)
val inversePrimaryDark = Color(0xFF2D6A44)
val surfaceDimDark = Color(0xFF101510)
val surfaceBrightDark = Color(0xFF353A36)
val surfaceContainerLowestDark = Color(0xFF0A0F0B)
val surfaceContainerLowDark = Color(0xFF181D18)
val surfaceContainerDark = Color(0xFF1C211C)
val surfaceContainerHighDark = Color(0xFF262B27)
val surfaceContainerHighestDark = Color(0xFF313631)

fun Int.blend(
    color: Int,
    @FloatRange(from = 0.0, to = 1.0) fraction: Float = 0.5f,
): Int = ColorUtils.blendARGB(this, color, fraction)

val seed = Color(0xFF4ADC8A)
