import { StyleSheet } from 'react-native';
import { Colors } from 'constants/Colors';

export const styles = StyleSheet.create({
  drawerDivider: {
    width: '80%',
    borderWidth: 1,
    borderColor: Colors.areaBase,
    marginTop: 16,
  },
  drawerEntry: {
    width: '80%',
    display: 'flex',
    alignItems: 'center',
    flexDirection: 'row',
    padding: 8,
  },
  mfaOverlay: {
    width: '100%',
    height: '100%',
  },
  mfaSecret: {
    display: 'flex',
    flexDirection: 'row',
    gap: 4,
  },
  mfaText: {
    fontSize: 11,
    color: Colors.labelText,
  },
  mfaIcon: {
    fontSize: 14,
    color: Colors.primaryButton,
  },
  mfaError: {
    width: '100%',
    height: 24,
    display: 'flex',
    alignItems: 'center',
  },
  mfaErrorLabel: {
    color: Colors.dangerText,
  },
  mfaControl: {
    height: 32,
    display: 'flex',
    flexDirection: 'row',
    width: '100%',
    justifyContent: 'flex-end',
    gap: 16,
  },
  mfaCancel: {
    width: 72,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: Colors.cancelButton,
    borderRadius: 4,
  },
  mfaCancelLabel: {
    color: Colors.cancelButtonText,
  },
  mfaConfirm: {
    width: 72,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: Colors.primaryButton,
    borderRadius: 4,
  },
  mfaConfirmLabel: {
    color: Colors.primaryButtonText,
  },
  mfaDisabled: {
    width: 72,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: Colors.disabledButton,
    borderRadius: 4,
  },
  mfaDisabledLabel: {
    color: Colors.disabledButtonText,
  },
  mfaBase: {
    position: 'absolute',
    top: 0,
    left: 0,
    width: '100%',
    height: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  },
  mfaContainer: {
    backgroundColor: Colors.modalBase,
    borderColor: Colors.modalBorder,
    borderWidth: 1,
    width: '80%',
    maxWidth: 400,
    display: 'flex',
    gap: 8,
    alignItems: 'center',
    borderRadius: 8,
    padding: 16,
  },
  mfaTitle: {
    fontSize: 20,
    color: Colors.descriptionText,
    paddingBottom: 8,
  },
  mfaDescription: {
    fontSize: 14,
    color: Colors.descriptionText,
    textAlign: 'center',
  },
  mfaCode: {
    width: 400,
    borderWidth: 1,
    borderColor: '#333333',
    width: '100%',
    opacity: 0,
  },
  content: {
    width: '100%',
    height: '100%',
    display: 'flex',
    paddingLeft: 16,
    paddingRight: 16,
    paddingTop: 8,
    backgroundColor: Colors.contentBase,
  },
  label: {
    color: Colors.labelText,
    padding: 4,
    fontFamily: 'Roboto',
  },
  radio: {
    marginLeft: 34,
    display: 'flex',
    flexDirection: 'row',
  },
  dismissButton: {
    padding: 12,
  },
  idleRadioCircle: {
    borderWidth: 1,
    borderColor: Colors.activeBorder,
    borderRadius: 8,
    width: 16,
    height: 16,
  },
  activeRadioCircle: {
    borderWidth: 1,
    borderColor: Colors.activeBorder,
    backgroundColor: Colors.activeFill,
    borderRadius: 8,
    width: 16,
    height: 16,
  },
  radioLabel: {
    color: Colors.linkText,
    paddingLeft: 8,
    fontFamily: 'Roboto',
  },
  group: {
    backgroundColor: Colors.areaBase,
    width: '100%',
    borderRadius: 8,
    marginBottom: 8,
  },
  divider: {
    width: '100%',
    height: 3,
    backgroundColor: Colors.contentBase,
  },
  entry: {
    width: '100%',
    display: 'flex',
    alignItems: 'center',
    flexDirection: 'row',
    padding: 4,
    height: 48,
  },
  icon: {
    flex: 1,
    alignItems: 'center',
  },
  option: {
    flex: 10,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
  },
  optionControl: {
    flex: 8,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
  },
  control: {
    flex: 4,
    display: 'flex',
  },
  labelText: {
    fontSize: 14,
    paddingRight: 8,
    color: Colors.descriptionText,
    fontFamily: 'Roboto',
  },
  optionText: {
    fontSize: 16,
    paddingRight: 8,
    color: Colors.linkText,
    fontFamily: 'Roboto',
  },
  optionLink: {
    fontSize: 16,
    paddingRight: 8,
    color: Colors.linkText,
    fontFamily: 'Roboto',
  },
  dangerLink: {
    fontSize: 16,
    paddingRight: 8,
    color: Colors.dangerText,
    fontFamily: 'Roboto',
  },
  track: {
    false: Colors.idleFill,
    true: Colors.activeFill,
  },
  notifications: {
    transform: [{ scaleX: .6 }, { scaleY: .6 }],
  },
  modalOverlay: {
    width: '100%',
    height: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: Colors.modalOverlay,
    opacity: 0.8,
  },
  modalContainer: {
    backgroundColor: Colors.modalBase,
    width: '90%',
    maxWidth: 400,
    display: 'flex',
    alignItems: 'center',
    borderRadius: 8,
    borderWidth: 1,
    borderColor: Colors.modalBorder,
  },
  modalHeader: {
    fontSize: 18,
    paddingTop: 16,
    paddingBottom: 16,
    color: Colors.labelText,
    fontFamily: 'Roboto',
  },
  modalClose: {
    position: 'absolute',
    width: '100%',
    display: 'flex',
    alignItems: 'flex-end',
  },
  modalBusy: {
  },
  modalDescription: {
    textAlign: 'center',
    fontSize: 14,
    color: Colors.descriptionText,
    paddingLeft: 16,
    paddingRight: 16,
    paddingBottom: 16,
  },
  delayMessage: {
    fontSize: 12,
    color: Colors.descriptionText,
    paddingBottom: 16,
  },
  modalInput: {
    marginRight: 16,
    marginLeft: 16,
    marginTop: 8,
    marginBottom: 8,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    flexDirection: 'row',
  },
  modeText: {
    fontSize: 14,
    paddingBottom: 16,
    color: Colors.linkText,
    fontFamily: 'Roboto',
  },
  dangerText: {
    fontSize: 14,
    paddingBottom: 16,
    color: Colors.dangerText,
    fontFamily: 'Roboto',
  },
  inputText: {
    flex: 1,
    padding: 8,
    borderRadius: 4,
    margin: 4,
    backgroundColor: Colors.inputBase,
    color: Colors.inputText,
  },
  inputVisibility: {
    position: 'absolute',
    right: 16,
  },
  enabledButton: {
    marginTop: 24,
    marginBottom: 16,
    borderRadius: 4,
    backgroundColor: Colors.primaryButton,
    width: '33%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: 32,
  },
  enabledButtonText: {
    color: Colors.primaryButtonText,
    fontFamily: 'Roboto',
  },
  disabledButton: {
    marginTop: 24,
    marginBottom: 16,
    borderRadius: 4,
    backgroundColor: Colors.disabledButton,
    width: '33%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: 32,
  },
  disabledButtonText: {
    color: Colors.disabledButtonText,
    fontFamily: 'Roboto',
  },
  dangerButton: {
    marginTop: 24,
    marginBottom: 16,
    borderRadius: 4,
    backgroundColor: Colors.dangerButton,
    width: '33%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: 32,
  },
  dangerButtonText: {
    color: Colors.dangerButtonText,
    fontFamily: 'Roboto',
  },
  closeButton: {
    marginTop: 8,
    marginBottom: 16,
    marginRight: 16,
    paddingTop: 8,
    paddingBottom: 8,
    paddingLeft: 32,
    paddingRight: 32,
    borderRadius: 4,
    borderWidth: 1,
    borderColor: Colors.closeButton,
  },
  closeButtonText: {
    color: Colors.closeButtonText,
    fontFamily: 'Roboto',
  },
  cancelButton: {
    marginTop: 24,
    marginBottom: 16,
    marginRight: 16,
    borderRadius: 4,
    backgroundColor: Colors.cancelButton,
    width: '33%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: 32,
  },
  cancelButtonText: {
    color: Colors.cancelButtonText,
    fontFamily: 'Roboto',
  },
  promptButton: {
    marginTop: 24,
    marginBottom: 16,
    borderRadius: 4,
    backgroundColor: Colors.primaryButton,
    width: '33%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: 32,
  },
  hintButtons: {
    display: 'flex',
    flexDirection: 'row',
    paddingBottom: 8,
  },
  buttons: {
    display: 'flex',
    flexDirection: 'row',
    padding: 8,
  },
  floatingInput: {
    color: Colors.inputText,
    paddingTop: 12,
  },
  floatingLabel: {
    color: Colors.text,
  },
  floatingCustomLabel: {
    colorFocused: Colors.inputPlaceholder,
    colorBlurred: Colors.inputPlaceholder,
    fontSizeFocused: 12,
    paddingTop: 4,
  },
  floatingContainer: {
    paddingHorizontal: 12,
    backgroundColor: Colors.inputBase,
    borderRadius: 8,
    height: 52,
  },
  availableStatus: {
    height: 18,
  },
  notAvailable: {
    color: Colors.dangerText,
  },
  rightButton: {
    width: '100%',
    display: 'flex',
    alignItems: 'flex-end',
  },
  modalList: {
    width: '100%',
    minHeight: 128,
    maxHeight: 256,
    borderTopWidth: 1,
    borderBottomWidth: 1,
    marginBottom: 8,
    borderColor: Colors.horizontalDivider,
    display: 'flex'
  },
  item: {
    width: '100%',
    display: 'flex',
    flexDirection: 'row',
    height: 48,
    paddingLeft: 16,
    paddingRight: 16,
    alignItems: 'center',
    borderColor: Colors.itemDivider,
    borderBottomWidth: 1,
  },
  detail: {
    paddingLeft: 12,
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    flexGrow: 1,
    flexShrink: 1,
  },
  restore: {
    color: Colors.linkText,
  },
  name: {
    color: Colors.text,
    fontSize: 14,
  },
  emptyLabel: {
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: 128,
  },
  emptyLabelText: {
    fontFamily: 'roboto',
    fontSize: 16,
    color: Colors.inputPlaceholder,
  },
  handle: {
    color: Colors.text,
    fontSize: 12,
  },
  verticalPad: {
    width: '100%',
    height: 32,
  },
  field: {
    input: {
      backgroundColor: Colors.inputBase,
      borderRadius: 8,
      minHeight: 48,
      maxHeight: 128,
    },
    inputText: {
      color: Colors.inputText,
    },
    label: {
      height: 16,
      paddingLeft: 8,
    },
    labelText: {
      color: Colors.inputPlaceholder,
      fontSize: 12,
    },
    container: { 
      width: '100%', 
      paddingLeft: 16,
      paddingRight: 16,
      paddingTop: 8,
    },
  },
});

