import { StyleSheet } from 'react-native';
import { Colors } from 'constants/Colors';

export const styles = StyleSheet.create({
  container: {
    width: '100%',
    height: '100%',
    display: 'flex',
    flexDirection: 'column',
    backgroundColor: Colors.screenBase,
    paddingLeft: 16,
    paddingRight: 16,
    paddingTop: 8,
  },
  title: {
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  header: {
    width: '100%',
    paddingBottom: 8,
    borderBottomWidth: 1,
    borderColor: Colors.itemDivider,
  },
  topbar: {
    borderTopWidth: 1,
    borderBottomWidth: 1,
    borderColor: Colors.itemDivider,
    paddingTop: 6,
    paddingBottom: 6,
    paddingLeft: 16,
    paddingRight: 16,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  searcharea: {
    borderBottomWidth: 1,
    borderColor: Colors.itemDivider,
  },
  searchbar: {
    display: 'flex',
    flexDirection: 'row',
    paddingTop: 8,
    paddingLeft: 8,
    paddingBottom: 8,
    alignItems: 'center',
  },
  filterwrapper: {
    display: 'flex',
    flexDirection: 'row',
    borderRadius: 4,
    backgroundColor: Colors.inputBase,
    alignItems: 'center',
    paddingTop: 4,
    paddingBottom: 4,
    width: '25%',
  },
  inputwrapper: {
    display: 'flex',
    flexDirection: 'row',
    borderRadius: 4,
    backgroundColor: Colors.inputBase,
    alignItems: 'center',
    flexGrow: 1,
    flexShrink: 1,
    marginRight: 8,
    paddingTop: 4,
    paddingBottom: 4,
  },
  inputfield: {
    flex: 1,
    textAlign: 'center',
    padding: 4,
    color: Colors.inputText,
    fontSize: 14,
  },
  icon: {
    paddingLeft: 8,
  },
  accounts: {
    flexGrow: 1,
    flexShrink: 1,
    width: '100%',
    minHeight: 0,
    paddingTop: 8,
  },
  empty: {
    flexGrow: 1,
    width: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    marginTop: 32,
  },
  emptyText: {
    color: Colors.unsetText,
    fontSize: 18,
  },
  addbottom: {
    marginRight: 8,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    padding: 8,
    borderRadius: 4,
  },
  bottomText: {
    color: Colors.primaryButtonText,
    paddingLeft: 8,
  },
  search: {
    backgroundColor: Colors.primaryButton,
    marginLeft: 8,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    padding: 8,
    borderRadius: 4,
  },
  close: {
    marginRight: 8,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    padding: 8,
    borderRadius: 4,
    paddingLeft: 8,
    color: Colors.text,
  },
  findarea: {
    borderTopWidth: 1,
    borderColor: Colors.itemDivider,
  }
})
