import { defineAnimation } from './util';
export function withDelay(delayMs, _nextAnimation) {
    'worklet';
    return defineAnimation(_nextAnimation, () => {
        'worklet';
        const nextAnimation = typeof _nextAnimation === 'function' ? _nextAnimation() : _nextAnimation;
        function delay(animation, now) {
            const { startTime, started, previousAnimation } = animation;
            if (now - startTime > delayMs) {
                if (!started) {
                    nextAnimation.onStart(nextAnimation, animation.current, now, previousAnimation);
                    animation.previousAnimation = null;
                    animation.started = true;
                }
                const finished = nextAnimation.onFrame(nextAnimation, now);
                animation.current = nextAnimation.current;
                return finished;
            }
            else if (previousAnimation) {
                const finished = previousAnimation.finished ||
                    previousAnimation.onFrame(previousAnimation, now);
                animation.current = previousAnimation.current;
                if (finished) {
                    animation.previousAnimation = null;
                }
            }
            return false;
        }
        function onStart(animation, value, now, previousAnimation) {
            animation.startTime = now;
            animation.started = false;
            animation.current = value;
            if (previousAnimation === animation) {
                animation.previousAnimation = previousAnimation.previousAnimation;
            }
            else {
                animation.previousAnimation = previousAnimation;
            }
        }
        const callback = (finished) => {
            if (nextAnimation.callback) {
                nextAnimation.callback(finished);
            }
        };
        return {
            isHigherOrder: true,
            onFrame: delay,
            onStart,
            current: nextAnimation.current,
            callback,
            previousAnimation: null,
            startTime: 0,
            started: false,
        };
    });
}
/**
 * @deprecated Kept for backward compatibility. Will be removed soon.
 */
export function delay(delayMs, _nextAnimation) {
    'worklet';
    console.warn('Method `delay` is deprecated. Please use `withDelay` instead');
    return withDelay(delayMs, _nextAnimation);
}
