### A base TSConfig for working with React Native.

Add the package to your `"devDependencies"`:

```sh
npm install --save-dev @tsconfig/react-native
yarn add --dev @tsconfig/react-native
```

Add to your `tsconfig.json`:

```json
"extends": "@tsconfig/react-native/tsconfig.json"
```

---

The `tsconfig.json`: 

```jsonc
{
  "$schema": "https://json.schemastore.org/tsconfig",
  "display": "React Native",
  "_version": "2.0.3",
  "compilerOptions": {
    "target": "esnext",
    "module": "commonjs",
    "types": ["react-native", "jest"],
    "lib": [
      "es2019"
    ],
    "allowJs": true,
    "jsx": "react-native",
    "noEmit": true,
    "isolatedModules": true,
    "strict": true,
    "moduleResolution": "node",
    "resolveJsonModule": true,
    "allowSyntheticDefaultImports": true,
    "forceConsistentCasingInFileNames": true,
    "esModuleInterop": true,
    "skipLibCheck": true
  },
  "exclude": [
    "node_modules",
    "babel.config.js",
    "metro.config.js",
    "jest.config.js"
  ]
}

```

You can find the [code here](https://github.com/tsconfig/bases/blob/master/bases/react-native.json).
