"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchAccessibilityState = matchAccessibilityState;
var _accessiblity = require("../accessiblity");
/**
 * Default accessibility state values based on experiments using accessibility
 * inspector/screen reader on iOS and Android.
 *
 * @see https://github.com/callstack/react-native-testing-library/wiki/Accessibility:-State
 */
const defaultState = {
  disabled: false,
  selected: false,
  checked: undefined,
  busy: false,
  expanded: undefined
};
function matchAccessibilityState(node, matcher) {
  const state = node.props.accessibilityState;
  return _accessiblity.accessibilityStateKeys.every(key => matchState(state, matcher, key));
}
function matchState(state, matcher, key) {
  return matcher[key] === undefined || matcher[key] === (state?.[key] ?? defaultState[key]);
}
//# sourceMappingURL=accessibilityState.js.map