import type { AccessibilityState } from 'react-native';
import type { ReactTestInstance } from 'react-test-renderer';
import { AccessibilityValueMatcher } from '../helpers/matchers/accessibilityValue';
import type { TextMatch } from '../matches';
import type { FindAllByQuery, FindByQuery, GetAllByQuery, GetByQuery, QueryAllByQuery, QueryByQuery } from './makeQueries';
import { CommonQueryOptions } from './options';
type ByRoleOptions = CommonQueryOptions & AccessibilityState & {
    name?: TextMatch;
    value?: AccessibilityValueMatcher;
};
export type ByRoleQueries = {
    getByRole: GetByQuery<TextMatch, ByRoleOptions>;
    getAllByRole: GetAllByQuery<TextMatch, ByRoleOptions>;
    queryByRole: QueryByQuery<TextMatch, ByRoleOptions>;
    queryAllByRole: QueryAllByQuery<TextMatch, ByRoleOptions>;
    findByRole: FindByQuery<TextMatch, ByRoleOptions>;
    findAllByRole: FindAllByQuery<TextMatch, ByRoleOptions>;
};
export declare const bindByRoleQueries: (instance: ReactTestInstance) => ByRoleQueries;
export {};
