"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchLabelText = matchLabelText;
var _matches = require("../../matches");
var _findAll = require("../findAll");
var _matchTextContent = require("./matchTextContent");
function matchLabelText(root, element, text, options = {}) {
  return matchAccessibilityLabel(element, text, options) || matchAccessibilityLabelledBy(root, element.props.accessibilityLabelledBy, text, options);
}
function matchAccessibilityLabel(element, text, options) {
  const {
    exact,
    normalizer
  } = options;
  return (0, _matches.matches)(text, element.props.accessibilityLabel, normalizer, exact);
}
function matchAccessibilityLabelledBy(root, nativeId, text, options) {
  if (!nativeId) {
    return false;
  }
  return (0, _findAll.findAll)(root, node => typeof node.type === 'string' && node.props.nativeID === nativeId && (0, _matchTextContent.matchTextContent)(node, text, options)).length > 0;
}
//# sourceMappingURL=matchLabelText.js.map