import { StyleSheet } from 'react-native';
import { Colors } from 'constants/Colors';

export const styles = StyleSheet.create({
  container: {
    width: '100%',
    height: '100%',
    display: 'flex',
    flexDirection: 'column',
    backgroundColor: Colors.contentBase,
  },
  title: {
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  inputwrapper: {
    display: 'flex',
    flexDirection: 'row',
    borderRadius: 4,
    backgroundColor: Colors.inputBase,
    alignItems: 'center',
    flexGrow: 1,
    flexShrink: 1,
    marginRight: 8,
    paddingTop: 4,
    paddingBottom: 4,
  },
  inputfield: {
    flex: 1,
    flexGrow: 1,
    textAlign: 'center',
    padding: 4,
    color: Colors.inputText,
    fontSize: 14,
  },
  addField: {
    width: '100%',
    borderWidth: 1,
    borderColor: Colors.lightgrey,
    borderRadius: 4,
    padding: 8,
    marginBottom: 8,
    maxHeight: 92,
    display: 'flex',
    flexDirection: 'row',
  },
  input: {
    fontSize: 14,
    flexGrow: 1,
  },
  icon: {
    paddingLeft: 8,
  },
  addbottom: {
    backgroundColor: Colors.primary,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    padding: 8,
    borderRadius: 4,
  },
  addtop: {
    backgroundColor: Colors.primary,
    marginLeft: 16,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    padding: 8,
    borderRadius: 4,
  },
  addtext: {
    paddingLeft: 8,
    color: Colors.white,
  },
  content: {
    flexGrow: 1,
    flexShrink: 1,
    paddingTop: 8,
  },
  notfound: {
    flexGrow: 1,
    flexShrink: 1,
    display: 'flex',
    alignItems: 'center',
    display: 'flex',
    justifyContent: 'center',
  },
  notfoundtext: {
    fontSize: 20,
    color: Colors.unsetText,
  },
  columnbottom: {
    paddingLeft: 24,
    paddingRight: 16,
    paddingTop: 8,
    paddingBottom: 16,
    borderTopWidth: 1,
    borderColor: Colors.horizontalDivider,
  },
  columntop: {
    paddingLeft: 24,
    paddingRight: 16,
    paddingBottom: 8,
    borderBottomWidth: 1,
    borderColor: Colors.horizontalDivider,
  },
  addWrapper: {
    display: 'flex',
    width: '100%',
    height: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: 'rgba(52, 52, 52, 0.8)'
  },
  addHeader: {
    fontSize: 18,
    paddingBottom: 8,
    color: Colors.text,
  },
  addMembers: {
    width: '100%',
    borderTopWidth: 1,
    borderBottomWidth: 1,
    borderColor: Colors.lightgrey,
    marginBottom: 16,
    marginTop: 16,
    height: 200,
  },
  empty: {
    color: Colors.descriptionText,
  },
  emptyMembers: {
    width: '100%',
    borderWidth: 1,
    borderColor: Colors.lightgrey,
    borderRadius: 4,
    marginBottom: 8,
    marginTop: 16,
    height: 200,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
  },
  cancel: {
    backgroundColor: Colors.cancelButton,
    borderRadius: 4,
    padding: 4,
    marginRight: 8,
    width: 72,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
  },
  save: {
    backgroundColor: Colors.primary,
    borderRadius: 4,
    paddingTop: 4,
    paddingBottom: 4,
    paddingLeft: 8,
    paddingRight: 8,
    marginRight: 8,
    minWidth: 72,
    height: 32,
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  saveText: {
    color: Colors.primaryButtonText,
    paddingRight: 4,
    paddingLeft: 4,
  },
  cancelText: {
    color: Colors.cancelButtonText,
  },
  sealedText: {
    color: Colors.text,
  },
  addControls: {
    display: 'flex',
    flexDirection: 'row',
  },
  sealed: {
    display: 'flex',
    flexDirection: 'row',
    flexGrow: 1,
    alignItems: 'center',
  },
  sealedText: {
    color: Colors.text,
  },
  track: {
    false: Colors.grey,
    true: Colors.background,
  },
  switch: {
    transform: [{ scaleX: .7 }, { scaleY: .7 }],
  },
  modalOverlay: { 
    width: '100%', 
    height: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: Colors.modalOverlay,
    opacity: 0.8,
  },
  modalContainer: {
    backgroundColor: Colors.modalBase,
    width: '80%',
    maxWidth: 400,
    display: 'flex',
    alignItems: 'center',
    borderRadius: 8,
    padding: 16,
    borderWidth: 1,
    borderColor: Colors.modalBorder,
  },
  field: {
    input: {
      backgroundColor: Colors.inputBase,
      borderRadius: 8,
      minHeight: 40,
      maxHeight: 128,
      paddingLeft: 8,
    },
    inputText: {
      color: Colors.inputText,
    },
    label: {
      height: 16,
      paddingLeft: 8,
    },
    labelText: {
      color: Colors.inputPlaceholder,
      fontSize: 12,
    },
    container: { 
      width: '100%',
    },
  },
});

