import { AnimationFunction, LayoutAnimationAndConfig } from './commonTypes';
import { EasingFn } from '../../Easing';
import { BaseAnimationBuilder } from './BaseAnimationBuilder';
import { StyleProps } from '../../commonTypes';
export declare class ComplexAnimationBuilder extends BaseAnimationBuilder {
    easingV?: EasingFn;
    rotateV?: string;
    type?: AnimationFunction;
    dampingV?: number;
    massV?: number;
    stiffnessV?: number;
    overshootClampingV?: number;
    restDisplacementThresholdV?: number;
    restSpeedThresholdV?: number;
    initialValues?: StyleProps;
    static createInstance: () => ComplexAnimationBuilder;
    static easing(easingFunction: EasingFn): ComplexAnimationBuilder;
    easing(easingFunction: EasingFn): ComplexAnimationBuilder;
    static rotate(degree: string): ComplexAnimationBuilder;
    rotate(degree: string): ComplexAnimationBuilder;
    static springify(): ComplexAnimationBuilder;
    springify(): ComplexAnimationBuilder;
    static damping(damping: number): ComplexAnimationBuilder;
    damping(damping: number): ComplexAnimationBuilder;
    static mass(mass: number): ComplexAnimationBuilder;
    mass(mass: number): ComplexAnimationBuilder;
    static stiffness(stiffness: number): ComplexAnimationBuilder;
    stiffness(stiffness: number): ComplexAnimationBuilder;
    static overshootClamping(overshootClamping: number): ComplexAnimationBuilder;
    overshootClamping(overshootClamping: number): ComplexAnimationBuilder;
    static restDisplacementThreshold(restDisplacementThreshold: number): ComplexAnimationBuilder;
    restDisplacementThreshold(restDisplacementThreshold: number): ComplexAnimationBuilder;
    static restSpeedThreshold(restSpeedThreshold: number): ComplexAnimationBuilder;
    restSpeedThreshold(restSpeedThreshold: number): ComplexAnimationBuilder;
    static withInitialValues(values: StyleProps): BaseAnimationBuilder;
    withInitialValues(values: StyleProps): BaseAnimationBuilder;
    getAnimationAndConfig(): LayoutAnimationAndConfig;
}
