import React from "react";
export function useCheckMounted() {
  const mounted = React.useRef(false);
  React.useEffect(() => {
    mounted.current = true;
    return () => {
      mounted.current = false;
    };
  }, []);
  return mounted;
}
//# sourceMappingURL=useCheckMounted.js.map