import type { ComponentType } from 'react';
export type RenderHookResult<Result, Props> = {
    rerender: (props: Props) => void;
    result: {
        current: Result;
    };
    unmount: () => void;
};
export type RenderHookOptions<Props> = Props extends object | string | number | boolean ? {
    initialProps: Props;
    wrapper?: ComponentType<any>;
} : {
    wrapper?: ComponentType<any>;
    initialProps?: never;
} | undefined;
export declare function renderHook<Result, Props>(renderCallback: (props: Props) => Result, options?: RenderHookOptions<Props>): RenderHookResult<Result, Props>;
