"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = render;
var _reactTestRenderer = _interopRequireDefault(require("react-test-renderer"));
var React = _interopRequireWildcard(require("react"));
var _act = _interopRequireDefault(require("./act"));
var _cleanup = require("./cleanup");
var _debugShallow = _interopRequireDefault(require("./helpers/debugShallow"));
var _debugDeep = _interopRequireDefault(require("./helpers/debugDeep"));
var _within = require("./within");
var _screen = require("./screen");
var _stringValidation = require("./helpers/stringValidation");
var _config = require("./config");
var _hostComponentNames = require("./helpers/host-component-names");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Renders test component deeply using react-test-renderer and exposes helpers
 * to assert on the output.
 */
function render(component, {
  wrapper: Wrapper,
  createNodeMock,
  unstable_validateStringsRenderedWithinText
} = {}) {
  (0, _hostComponentNames.configureHostComponentNamesIfNeeded)();
  if (unstable_validateStringsRenderedWithinText) {
    return renderWithStringValidation(component, {
      wrapper: Wrapper,
      createNodeMock
    });
  }
  const wrap = element => Wrapper ? /*#__PURE__*/React.createElement(Wrapper, null, element) : element;
  const renderer = renderWithAct(wrap(component), createNodeMock ? {
    createNodeMock
  } : undefined);
  return buildRenderResult(renderer, wrap);
}
function renderWithStringValidation(component, {
  wrapper: Wrapper,
  createNodeMock
} = {}) {
  const handleRender = (_, phase) => {
    if (phase === 'update') {
      (0, _stringValidation.validateStringsRenderedWithinText)(_screen.screen.toJSON());
    }
  };
  const wrap = element => /*#__PURE__*/React.createElement(React.Profiler, {
    id: "renderProfiler",
    onRender: handleRender
  }, Wrapper ? /*#__PURE__*/React.createElement(Wrapper, null, element) : element);
  const renderer = renderWithAct(wrap(component), createNodeMock ? {
    createNodeMock
  } : undefined);
  (0, _stringValidation.validateStringsRenderedWithinText)(renderer.toJSON());
  return buildRenderResult(renderer, wrap);
}
function buildRenderResult(renderer, wrap) {
  const update = updateWithAct(renderer, wrap);
  const instance = renderer.root;
  const unmount = () => {
    (0, _act.default)(() => {
      renderer.unmount();
    });
  };
  (0, _cleanup.addToCleanupQueue)(unmount);
  const result = {
    ...(0, _within.getQueriesForElement)(instance),
    update,
    unmount,
    container: instance,
    rerender: update,
    // alias for `update`
    toJSON: renderer.toJSON,
    debug: debug(instance, renderer)
  };
  (0, _screen.setRenderResult)(result);
  return result;
}
function renderWithAct(component, options) {
  let renderer;
  (0, _act.default)(() => {
    renderer = _reactTestRenderer.default.create(component, options);
  });

  // @ts-ignore act is sync, so renderer is always initialised here
  return renderer;
}
function updateWithAct(renderer, wrap) {
  return function (component) {
    (0, _act.default)(() => {
      renderer.update(wrap(component));
    });
  };
}
function debug(instance, renderer) {
  function debugImpl(options) {
    const {
      defaultDebugOptions
    } = (0, _config.getConfig)();
    const debugOptions = typeof options === 'string' ? {
      ...defaultDebugOptions,
      message: options
    } : {
      ...defaultDebugOptions,
      ...options
    };
    if (typeof options === 'string') {
      // eslint-disable-next-line no-console
      console.warn('Using debug("message") is deprecated and will be removed in future release, please use debug({ message; "message" }) instead.');
    }
    const json = renderer.toJSON();
    if (json) {
      return (0, _debugDeep.default)(json, debugOptions);
    }
  }
  debugImpl.shallow = message => (0, _debugShallow.default)(instance, message);
  return debugImpl;
}
//# sourceMappingURL=render.js.map