"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindByLabelTextQueries = void 0;
var _findAll = require("../helpers/findAll");
var _matchLabelText = require("../helpers/matchers/matchLabelText");
var _makeQueries = require("./makeQueries");
function queryAllByLabelText(instance) {
  return (text, queryOptions) => {
    return (0, _findAll.findAll)(instance, node => typeof node.type === 'string' && (0, _matchLabelText.matchLabelText)(instance, node, text, queryOptions), queryOptions);
  };
}
const getMultipleError = labelText => `Found multiple elements with accessibilityLabel: ${String(labelText)} `;
const getMissingError = labelText => `Unable to find an element with accessibilityLabel: ${String(labelText)}`;
const {
  getBy,
  getAllBy,
  queryBy,
  queryAllBy,
  findBy,
  findAllBy
} = (0, _makeQueries.makeQueries)(queryAllByLabelText, getMissingError, getMultipleError);
const bindByLabelTextQueries = instance => ({
  getByLabelText: getBy(instance),
  getAllByLabelText: getAllBy(instance),
  queryByLabelText: queryBy(instance),
  queryAllByLabelText: queryAllBy(instance),
  findByLabelText: findBy(instance),
  findAllByLabelText: findAllBy(instance)
});
exports.bindByLabelTextQueries = bindByLabelTextQueries;
//# sourceMappingURL=labelText.js.map