# Databag Design Guidelines & Resources

A collection of design contribution guidelines and resources for our Databag product.

> **All participating designers are highly encouraged to shape and evolve these guidelines!**

## Welcome

Databag is a product targeted for the decentralized web community. It is a federeated messenger that gives people back their privacy and control of their data.

## How to contribute design

1. Check out open [issues](https://github.com/balzack/databag/issues) here on GitHub (we label them with `design: required`)
2. Feel free to open an issue on your own if you find something you would like to contribute to the project and use the `design: idea` label for it.
3. There are no existing figma files yet, for now create new ones and share them publicly
4. Add your contributions to an issue and we promise we will review your contribution carefully and foster discussions

**We encourage you to:**

- Get in touch with the team by starting a discussion on [GitHub](https://github.com/balzack/databag/discussions).

## Target audience

The initial users are typically very technical, but hopefully this product will be embedded into consumer electronics and reach a much less technical audience. The design may benefit by exposing some technical attributes. For example, with a self-hosted product the users my be interested in knowing where their data actually lives.

## Design relevant materials

Here is a list of design relevant information and materials:

### Fonts

Currently we're using Roboto everywhere.

### Colors

We're using shades of green deliberately staying away from the corporate blue. The current background color is (#8fbea7) with the primary button color (#448866).

### Logos

We don't really have a logo yet, and are currently just using a scaled image from the app as the [icon](https://github.com/balzack/databag/blob/main/doc/icon.png)

### Design Files, Screenshots, etc

We don't have any design files yet. Initially you can reference screenshots for the [browser app](https://github.com/balzack/databag/blob/main/doc/browser.png) and [mobile app](https://github.com/balzack/databag/blob/main/doc/mobile.png)

## License

All design work is licensed under the
[Apache-2.0](https://github.com/balzack/databag/blob/main/LICENSE)

[(Back to top)](#-table-of-contents)
