# -keepclassmembers class **.R$* {
#     public static <fields>;
# }

# -keep class **.R$*

# Optimizations: If you don't want to optimize, use the
# proguard-android.txt configuration file instead of this one, which
# turns off the optimization flags.  Adding optimization introduces
# certain risks, since for example not all optimizations performed by
# ProGuard works on all versions of Dalvik.  The following flags turn
# off various optimizations known to have issues, but the list may not
# be complete or up to date. (The "arithmetic" optimization can be
# used if you are only targeting Android 2.0 or later.)  Make sure you
# test thoroughly if you go this route.

#-optimizations !code/simplification/arithmetic,!code/simplification/cast,!field/*,!class/merging/*
###-optimizations code/simplification/arithmetic,!code/simplification/cast,!field/*,!class/merging/*
#-optimizationpasses 5
###-optimizationpasses 10
#-allowaccessmodification
-dontpreverify
#-dontobfuscate


#-mergeinterfacesaggressively
-dontusemixedcaseclassnames
-dontskipnonpubliclibraryclasses
-verbose

#-whyareyoukeeping class android.support.v7.appcompat.R$style
#-whyareyoukeeping class android.support.v7.view.ContextThemeWrapper

#-whyareyoukeeping class android.support.v4.app.ActivityCompat
#-whyareyoukeeping class android.support.v4.view.ViewCompat

# -printseeds



# -keepattributes *Annotation*
# -keep public class com.google.vending.licensing.ILicensingService
# -keep public class com.android.vending.licensing.ILicensingService

# For native methods, see http://proguard.sourceforge.net/manual/examples.html#native
# -keepclasseswithmembernames class * {
#     native <methods>;
# }

# keep setters in Views so that animations can still work.
# see http://proguard.sourceforge.net/manual/examples.html#beans
-keepclassmembers public class * extends android.view.View {
   void set*(***);
   *** get*();
}

# We want to keep methods in Activity that could be used in the XML attribute onClick
-keepclassmembers class * extends android.app.Activity {
   public void *(android.view.View);
}

# For enumeration classes, see http://proguard.sourceforge.net/manual/examples.html#enumerations
-keepclassmembers enum * {
    public static **[] values();
    public static ** valueOf(java.lang.String);
}

-keepclassmembers class * implements android.os.Parcelable {
  public static final android.os.Parcelable$Creator CREATOR;
}

-keepclassmembers class **.R$* {
    public static <fields>;
}

# The support library contains references to newer platform versions.
# Don't warn about those in case this app is linking against an older
# platform version.  We know about them, and they are safe.
-dontwarn android.support.**

# Understand the @Keep support annotation.
#-keep class android.support.annotation.Keep

#-keep @android.support.annotation.Keep class * {*;}

# -keepclasseswithmembers class * {
#     @android.support.annotation.Keep <methods>;
# }

# -keepclasseswithmembers class * {
#     @android.support.annotation.Keep <fields>;
# }

# -keepclasseswithmembers class * {
#     @android.support.annotation.Keep <init>(...);
# }
