package com.darkrockstudios.apps.hammer.projects.repository

import com.darkrockstudios.apps.hammer.projects.ProjectsSyncData
import com.darkrockstudios.apps.hammer.projects.ProjectsSynchronizationSession
import io.mockk.coEvery
import io.mockk.coVerify
import kotlinx.coroutines.test.runTest
import org.junit.jupiter.api.Test
import kotlin.test.assertTrue
import kotlin.time.Instant

class ProjectsRepositoryEndSyncTest : ProjectsRepositoryBaseTest() {

	@Test
	fun `End Sync, conflicting project sync session`() = runTest {
		val syncId = "sync-id"
		coEvery { projectsSessionManager.findSession(any()) } returns null

		createProjectsRepository().apply {
			val result = endProjectsSync(userId, syncId)
			assertTrue(result.isFailure)
			coVerify(exactly = 0) { projectsSessionManager.terminateSession(any()) }
		}
	}

	@Test
	fun `End Sync, success`() = runTest {
		val userId = 1L
		val syncId = "sync-id"

		val session = ProjectsSynchronizationSession(
			userId = userId,
			syncId = syncId,
			started = Instant.DISTANT_PAST,
		)
		coEvery { projectsSessionManager.findSession(any()) } returns session
		coEvery { projectsSessionManager.terminateSession(userId) } returns true

		coEvery { projectsSessionManager.createNewSession(any(), any()) } returns syncId

		coEvery { projectsDatasource.getProjects(userId) } returns emptySet()
		coEvery { projectsDatasource.loadSyncData(userId) } returns
			ProjectsSyncData(
				lastSync = Instant.DISTANT_PAST,
				deletedProjects = emptySet()
			)

		createProjectsRepository().apply {
			val result = endProjectsSync(userId, syncId)
			assertTrue(result.isSuccess)

			coVerify { projectsSessionManager.terminateSession(userId) }
		}
	}
}