package com.darkrockstudios.apps.hammer.admin

import com.darkrockstudios.apps.hammer.base.validate.EmailValidator
import com.darkrockstudios.apps.hammer.utilities.Msg
import com.darkrockstudios.apps.hammer.utilities.ServerResult

class AdminComponent(
	private val whiteListRepository: WhiteListRepository,
) {
	suspend fun getWhiteList(): List<String> {
		return whiteListRepository.getWhiteList()
	}

	suspend fun addToWhiteList(email: String): ServerResult<Unit> {
		return if (EmailValidator.validate(email)) {
			whiteListRepository.addToWhiteList(email)
			ServerResult.success(Unit)
		} else {
			ServerResult.failure("Invalid email", Msg.r("api_admin_addtowhitelist_invalidemail"))
		}
	}

	suspend fun removeFromWhiteList(email: String) {
		whiteListRepository.removeFromWhiteList(email)
	}

	suspend fun enableWhiteList() {
		whiteListRepository.setWhiteListEnabled(true)
	}

	suspend fun disableWhiteList() {
		whiteListRepository.setWhiteListEnabled(false)
	}
}